//
//  OPRoomLayer.m
//  The Obfuscated Path
//
//  Created by ss2cire on 12/7/08.
//  Copyright 2008 GryphonClaw Software. All rights reserved.
//

#import "OPRoomLayer.h"
#import "OPSprite.h"
#import "OPTextureManager.h"
#import "OPApplication.h"

@implementation OPRoomLayer
- (id)initLayerData:(NSString *)theData
{
	self = [super init];

	if(self != nil) {
		NSArray *lines = [theData componentsSeparatedByString:@"\n"];
		int i, j;
		for(j = 0; j < ROOMHEIGHT; j++) {
			NSArray *cells = [[lines objectAtIndex:((ROOMHEIGHT - 1) - j)] componentsSeparatedByString:@","];
			for(i = 0; i < ROOMWIDTH; i++) {
				layerData[i][j] = [self spriteWithX:(i * 32) Y:(j * 32) andTextureCode:[cells objectAtIndex:i]];
			}
		}
	}
	return self;
}

- (void)dealloc
{
	int i, j;
	
	for(j = 0; j < ROOMHEIGHT; j++) {
		for(i = 0; i < ROOMWIDTH; i++) {
			[layerData[i][j] release];
		}
	}
	[super dealloc];
}

- (void)draw
{
	int i, j;
	for(j = 0; j < ROOMHEIGHT; j++) {
		for(i = 0; i < ROOMWIDTH; i++) {
			[layerData[i][j] draw];
		}
	}
}

- (void)update
{
	int i, j;
	
	for(j = 0; j < ROOMHEIGHT; j++) {
		for(i = 0; i < ROOMWIDTH; i++) {
			[layerData[i][j] update];
		}
	}
}

- (NSString *)textureNameForCode:(NSString *)code
{
	return [[NSApp tileMap] objectForKey:code];
}

- (OPSprite *)tileAtX:(int)x andY:(int)y
{
	int indexX = (x / 32);
	int indexY = (y / 32);
	OPSprite *theSprite = nil;
	if( ((indexX >= 0) && (indexX < ROOMWIDTH)) && ((indexY >= 0) && (indexY <= 10)) ) {
		theSprite = layerData[indexX][indexY];
	}

	return theSprite;
}

- (void)setTile:(OPSprite *)sprite atX:(int)x andY:(int)y
{
	OPSprite *previousSprite = layerData[x][y];
	layerData[x][y] = [sprite retain];
	[previousSprite release];
}

- (OPSprite *)spriteWithX:(int)x Y:(int)y andTextureCode:(NSString *)textureCode
{
	NSString *textureName = [self textureNameForCode:textureCode];
	OPSprite *theSprite = nil;
	if(textureName != nil) {
		theSprite = [[OPSprite alloc] initWithLocation:OPMakePoint(x, y) andSize:OPMakeSize(32, 32)];
		[theSprite setTexture:[[OPTextureManager sharedManager] textureWithName:textureName]];
	}
	return theSprite;
}
@end
